;;; -*- Lisp -*-

(defpackage #:clocc-port-system
  (:use #:common-lisp #:asdf))
(in-package #:clocc-port-system)

(defclass gray-streams (component) ())

(defmethod perform ((operation compile-op) (component gray-streams))
  #+cmu (require :cmucl-graystream)
  t)

(defmethod perform ((operation load-op) (component gray-streams))
  #+cmu (require :cmucl-graystream)
  t)

(defsystem clocc-port
  :components ((:gray-streams "vendor-gray-streams")
	       (:file "ext")
	       (:file "gray" :depends-on ("ext" "vendor-gray-streams"))
	       (:file "net" :depends-on ("ext" "sys"))
	       (:file "path" :depends-on ("ext"))
	       (:file "proc" :depends-on ("ext"))
	       (:file "shell" :depends-on ("ext"))
	       (:file "sys" :depends-on ("ext" "path")))
  :depends-on (#+(or cmu sbcl) :db-sockets))
